<!--
title: 'Serverless Framework Documentation'
short_title: 'Introduction to the Serverless Framework'
description: 'An introduction to the Serverless Framework, its philosophy, overview, and key highlights. Learn how to build serverless applications efficiently with minimal maintenance.'
keywords:
  [
    'Serverless Framework',
    'AWS Lambda',
    'Serverless Documentation',
    'Serverless Architectures',
    'Cloud Infrastructure',
    'Serverless CLI',
    'Serverless Dashboard',
  ]
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/)

<!-- DOCS-SITE-LINK:END -->

# Serverless Framework - An Introduction

## Philosophy

**_Build applications that demand attention, not maintenance._**

In 2014, AWS Lambda was introduced offering a more efficient compute service in the cloud. With features like auto-scaling and no cost when idle, AWS Lambda offers a compute experience that demands so little maintenance it feels _"serverless"_.

Months later, the Serverless Framework was created to streamline the deployment of various use-cases on AWS Lambda. The Serverless Framework introduced the concept of _"serverless architectures"_, a transformative approach to building applications on the cloud, integrating AWS Lambda and cloud infrastructure with similar "serverless" qualities, to enable developers to create entire applications that scale massively with minimal maintenance.

Today, the Serverless Framework continues to be the original, leading and most trusted tool for enterprises and start-ups building serverless architectures. Renowned Fortune 500 companies such as the _New York Times_, _Nike_, and _EA Games_ utilize it, while numerous startups have reached unicorn valuations and achieved notable exits using the Framework. These successes have been accomplished with relatively small engineering teams, leveraging the power of serverless architectures.

The mission of the Serverless Framework is to empower all developers to build more and manage less.

## Overview

The Serverless Framework consists of a Command Line Interface and an optional Dashboard, and helps you deploy code and infrastructure together on Amazon Web Services, while increasingly supporting other cloud providers. The Framework is a YAML-based experience that uses simplified syntax to help you deploy complex infrastructure patterns easily, without needing to be a cloud expert. It is developed and maintained by Serverless Inc., a specialized software company based in San Francisco, California. Initially launched as an open-source project, the Framework has since transitioned to a SaaS product to better support its scalability and the extensive infrastructure capabilities it offers.

## Highlights

- **Empowerment:** Innovate faster by spending less time on infrastructure management.
- **Versatility:** Tackle diverse serverless use cases, from APIs and scheduled tasks to web sockets and data pipelines.
- **Infra & Code:** Streamline development with code and infrastructure deployment handled together.
- **Ease of Use:** Deploy complex applications without deep cloud infrastructure expertise, thanks to approachable YAML configuration.
- **Language Agnostic:** Develop in your preferred language – Node.js, Python, Java, Go, C#, Ruby, Swift, Kotlin, PHP, Scala, or F# – the Framework supports them all.
- **Full Lifecycle:** Build, deploy, monitor, update, and troubleshoot serverless applications with ease.
- **Scalable Organization:** Structure large projects and teams efficiently with built-in support for stages and project composition.
- **Plugin Ecosystem:** Extend and modify the Framework's functionality with a rich plugin ecosystem.
- **Vibrant Community:** Get support and connect with a passionate community of Serverless developers.

## Next Steps

Get started with the Serverless Framework on AWS [via this guide](https://serverless.com/framework/docs/getting-started/).

Have questions? Join thousands of other developers in our [Slack Channel](https://serverless.com/slack).

After that, we recommend you...

- [Learn Serverless Framework's Core Concepts](https://www.serverless.com/framework/docs/providers/aws/guide/intro)
- [Get inspiration from these Serverless Framework Templates](https://github.com/serverless/examples)
- [Discover all of the events that can trigger AWS Lambda functions](https://www.serverless.com/framework/docs/providers/aws/guide/events)
- [Bookmark Serverless Framework's `serverless.yml` guide](https://www.serverless.com/framework/docs/providers/aws/guide/serverless.yml)
- [Search the plugins registry to extend Serverless Framework](https://www.serverless.com/plugins)
